﻿using System;
using System.Security.Cryptography.X509Certificates;

namespace VIRP.EFR.BLL
{
    internal class CertificateService
    {
        private VistaImagingConfigurationService ConfigurationServiceRef;
        private VistaImagingConfigurationService ConfigurationService
        {
            get
            {
                if (this.ConfigurationServiceRef == null)
                    this.ConfigurationServiceRef = new VistaImagingConfigurationService();

                return this.ConfigurationServiceRef;
            }
        }

        public X509Certificate2 GetCertificate(string currentUser, int currentRegistryId)
        {
            X509Certificate2 result = null;

            X509Store store = null;
            try
            {
                store = new X509Store(StoreLocation.LocalMachine);

                store.Open(OpenFlags.ReadOnly);

                X509Certificate2Collection certCollection = store.Certificates;
                if (certCollection == null || certCollection.Count == 0)
                    throw new Exception("Cannot get certificate collection from StoreLocation = LocalMachine.");

                var thumbprint = this.GetCertificateThumbprint(currentUser, currentRegistryId);

                LogManager.LogInformation(string.Format("Trying to find certificate with Thumbprint: {0}.", thumbprint), string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, currentRegistryId);
                var tryFindCert = certCollection.Find(X509FindType.FindByThumbprint, thumbprint, true);

                if (tryFindCert.Count > 0)
                {
                    result = tryFindCert[0];
                    LogManager.LogInformation(string.Format("Found certificate: {0}.", result.Issuer), string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, currentRegistryId);
                }
                else
                    throw new Exception("Cannot get certificate from StoreLocation = LocalMachine.");
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, currentRegistryId);
                throw;
            }
            finally
            {
                if (store != null)
                    store.Close();
            }

            return result;
        }

        private string GetCertificateThumbprint(string currentUser, int currentRegistryId)
        {
            string result = this.ConfigurationService.GetConfiguration(currentUser, currentRegistryId).CERTIFICATE_THUMBPRINT;

            if (string.IsNullOrEmpty(result))
                throw new Exception("Cannot get Certificate Thumbprint: Unknown Source.");

            return result;
        }
    }
}